/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.stone;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlockPeat;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.plants.BlockShortGrassTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariantFallable;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockRockVariantConnected
extends BlockRockVariantFallable {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public static void spreadGrass(World world, BlockPos pos, IBlockState us, Random rand) {
        block8: {
            int neighborLight;
            BlockPos upPos;
            block6: {
                Block usBlock;
                block7: {
                    upPos = pos.func_177984_a();
                    IBlockState up = world.func_180495_p(upPos);
                    if (!up.func_185904_a().func_76224_d() && ((neighborLight = world.func_175671_l(upPos)) >= 4 || up.getLightOpacity((IBlockAccess)world, upPos) <= 2)) break block6;
                    usBlock = us.func_177230_c();
                    if (!(usBlock instanceof BlockPeat)) break block7;
                    world.func_175656_a(pos, BlocksTFC.PEAT.func_176223_P());
                    break block8;
                }
                if (!(usBlock instanceof BlockRockVariant)) break block8;
                BlockRockVariant rock = (BlockRockVariant)usBlock;
                world.func_175656_a(pos, rock.getVariant(rock.getType().getNonGrassVersion()).func_176223_P());
                break block8;
            }
            if (neighborLight >= 9) {
                for (int i = 0; i < 4; ++i) {
                    IBlockState targetUpState;
                    BlockPos targetUp;
                    BlockPos target = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (world.func_189509_E(target) || !world.func_175667_e(target)) {
                        return;
                    }
                    IBlockState current = world.func_180495_p(target);
                    if (!BlocksTFC.isSoil(current) || BlocksTFC.isGrass(current) || world.func_175671_l(targetUp = target.func_177984_a()) < 4 || (targetUpState = world.func_180495_p(targetUp)).func_185904_a().func_76224_d() || targetUpState.getLightOpacity((IBlockAccess)world, targetUp) > 3) continue;
                    Block currentBlock = current.func_177230_c();
                    if (currentBlock instanceof BlockPeat) {
                        world.func_175656_a(target, BlocksTFC.PEAT_GRASS.func_176223_P());
                        continue;
                    }
                    if (!(currentBlock instanceof BlockRockVariant)) continue;
                    Rock.Type spreader = Rock.Type.GRASS;
                    Block usBlock = us.func_177230_c();
                    if (usBlock instanceof BlockRockVariant && ((BlockRockVariant)usBlock).getType() == Rock.Type.DRY_GRASS) {
                        spreader = Rock.Type.DRY_GRASS;
                    }
                    BlockRockVariant block = (BlockRockVariant)current.func_177230_c();
                    world.func_175656_a(target, block.getVariant(block.getType().getGrassVersion(spreader)).func_176223_P());
                }
                for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
                    if (plant.getPlantType() != Plant.PlantType.SHORT_GRASS || !(rand.nextFloat() < 0.5f)) continue;
                    float temp = ClimateTFC.getActualTemp(world, upPos);
                    BlockShortGrassTFC plantBlock = BlockShortGrassTFC.get(plant);
                    if (!world.func_175623_d(upPos) || !plant.isValidLocation(temp, ChunkDataTFC.getRainfall(world, upPos), Math.subtractExact(world.func_175642_b(EnumSkyBlock.SKY, upPos), world.func_175657_ab())) || !plant.isValidGrowthTemp(temp) || !(rand.nextDouble() < plantBlock.getGrowthRate(world, upPos))) continue;
                    world.func_175656_a(upPos, plantBlock.func_176223_P());
                }
            }
        }
    }

    public BlockRockVariantConnected(Rock.Type type, Rock rock) {
        super(type, rock);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        pos = pos.func_177982_a(0, -1, 0);
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(BlocksTFC.isGrass(world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH))))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(BlocksTFC.isGrass(world.func_180495_p(pos.func_177972_a(EnumFacing.EAST))))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(BlocksTFC.isGrass(world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH))))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(BlocksTFC.isGrass(world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)))));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }
}

